/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.tuple.Triple;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Quadruple<T1, T2, T3, T4>(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
        return new Quadruple<T1, T2, T3, T4>(val1, val2, val3, val4);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@NotNull Tuple<T1, T2> left, @NotNull Tuple<T3, T4> right) {
        return new Quadruple<T1, T2, T3, T4>(left.left(), left.right(), right.left(), right.right());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<T1, Triple<T2, T3, T4>> slice1() {
        return new Tuple<T1, Triple<T2, T3, T4>>(this.val1, new Triple<T2, T3, T4>(this.val2, this.val3, this.val4));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<Tuple<T1, T2>, Tuple<T3, T4>> slice2() {
        return new Tuple<Tuple<T1, T2>, Tuple<T3, T4>>(new Tuple<T1, T2>(this.val1, this.val2), new Tuple<T3, T4>(this.val3, this.val4));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<Triple<T1, T2, T3>, T4> slice3() {
        return new Tuple<Triple<T1, T2, T3>, T4>(new Triple<T1, T2, T3>(this.val1, this.val2, this.val3), this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T, T2, T3, T4> map1(@NotNull Function<T1, T> mapper) {
        return new Quadruple<T, T2, T3, T4>(Objects.requireNonNull(mapper).apply(this.val1), this.val2, this.val3, this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T> Function<Quadruple<T1, T2, T3, T4>, Quadruple<T, T2, T3, T4>> mapping1(@NotNull Function<T1, T> mapper) {
        return triple -> triple.map1(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T, T3, T4> map2(@NotNull Function<T2, T> mapper) {
        return new Quadruple<T1, T, T3, T4>(this.val1, Objects.requireNonNull(mapper).apply(this.val2), this.val3, this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T> Function<Quadruple<T1, T2, T3, T4>, Quadruple<T1, T, T3, T4>> mapping2(@NotNull Function<T2, T> mapper) {
        return triple -> triple.map2(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T2, T, T4> map3(@NotNull Function<T3, T> mapper) {
        return new Quadruple<T1, T2, T, T4>(this.val1, this.val2, Objects.requireNonNull(mapper).apply(this.val3), this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T> Function<Quadruple<T1, T2, T3, T4>, Quadruple<T1, T2, T, T4>> mapping3(@NotNull Function<T3, T> mapper) {
        return triple -> triple.map3(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T2, T3, T> map4(@NotNull Function<T4, T> mapper) {
        return new Quadruple<T1, T2, T3, T>(this.val1, this.val2, this.val3, Objects.requireNonNull(mapper).apply(this.val4));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T> Function<Quadruple<T1, T2, T3, T4>, Quadruple<T1, T2, T3, T>> mapping4(@NotNull Function<T4, T> mapper) {
        return triple -> triple.map4(mapper);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T2, T1, T3, T4> swap12() {
        return new Quadruple<T2, T1, T3, T4>(this.val2, this.val1, this.val3, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T3, T2, T1, T4> swap13() {
        return new Quadruple<T3, T2, T1, T4>(this.val3, this.val2, this.val1, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T4, T2, T3, T1> swap14() {
        return new Quadruple<T4, T2, T3, T1>(this.val4, this.val2, this.val3, this.val1);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T3, T2, T4> swap23() {
        return new Quadruple<T1, T3, T2, T4>(this.val1, this.val3, this.val2, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T4, T3, T2> swap24() {
        return new Quadruple<T1, T4, T3, T2>(this.val1, this.val4, this.val3, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T2, T4, T3> swap34() {
        return new Quadruple<T1, T2, T4, T3>(this.val1, this.val2, this.val4, this.val3);
    }

    public static <T1, T2, T3, T4, A1, A2, A3, A4, R1, R2, R3, R4> Collector<Quadruple<T1, T2, T3, T4>, Quadruple<A1, A2, A3, A4>, Quadruple<R1, R2, R3, R4>> collector(final Collector<T1, A1, R1> val1, final Collector<T2, A2, R2> val2, final Collector<T3, A3, R3> val3, final Collector<T4, A4, R4> val4) {
        return new Collector<Quadruple<T1, T2, T3, T4>, Quadruple<A1, A2, A3, A4>, Quadruple<R1, R2, R3, R4>>(){

            @Override
            public Supplier<Quadruple<A1, A2, A3, A4>> supplier() {
                Supplier firstSupplier = val1.supplier();
                Supplier secondSupplier = val2.supplier();
                Supplier thirdSupplier = val3.supplier();
                Supplier fourthSupplier = val4.supplier();
                return () -> Quadruple.of(firstSupplier.get(), secondSupplier.get(), thirdSupplier.get(), fourthSupplier.get());
            }

            @Override
            public BiConsumer<Quadruple<A1, A2, A3, A4>, Quadruple<T1, T2, T3, T4>> accumulator() {
                BiConsumer firstAccumulator = val1.accumulator();
                BiConsumer secondAccumulator = val2.accumulator();
                BiConsumer thirdAccumulator = val3.accumulator();
                BiConsumer fourthAccumulator = val4.accumulator();
                return (a, b) -> {
                    firstAccumulator.accept(a.val1, b.val1);
                    secondAccumulator.accept(a.val2, b.val2);
                    thirdAccumulator.accept(a.val3, b.val3);
                    fourthAccumulator.accept(a.val4, b.val4);
                };
            }

            @Override
            public BinaryOperator<Quadruple<A1, A2, A3, A4>> combiner() {
                BinaryOperator firstCombiner = val1.combiner();
                BinaryOperator secondCombiner = val2.combiner();
                BinaryOperator thirdCombiner = val3.combiner();
                BinaryOperator fourthCombiner = val4.combiner();
                return (a, b) -> Quadruple.of(firstCombiner.apply(a.val1, b.val1), secondCombiner.apply(a.val2, b.val2), thirdCombiner.apply(a.val3, b.val3), fourthCombiner.apply(a.val4, b.val4));
            }

            @Override
            public Function<Quadruple<A1, A2, A3, A4>, Quadruple<R1, R2, R3, R4>> finisher() {
                Function firstFinisher = val1.finisher();
                Function secondFinisher = val2.finisher();
                Function thirdFinisher = val3.finisher();
                Function fourthFinisher = val4.finisher();
                return a -> Quadruple.of(firstFinisher.apply(a.val1), secondFinisher.apply(a.val2), thirdFinisher.apply(a.val3), fourthFinisher.apply(a.val4));
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                HashSet<Collector.Characteristics> characteristics = new HashSet<Collector.Characteristics>(val1.characteristics());
                characteristics.retainAll(val2.characteristics());
                characteristics.retainAll(val3.characteristics());
                characteristics.retainAll(val4.characteristics());
                return characteristics;
            }
        };
    }
}

